<!-- Testimonials Section -->
<section id="testimonials" class="testimonials-section py-5">
    <div class="container">
        <div class="text-center mb-5">
            <span class="section-label">What People Say</span>
            <h2 class="section-title">Customer Reviews</h2>
            <p class="section-subtitle">See what our customers are saying about us</p>
        </div>

        <div class="row g-4">
            <?php foreach ($testimonials as $testimonial): ?>
            <div class="col-md-4">
                <div class="testimonial-card">
                    <div class="testimonial-rating mb-3">
                        <?php for ($i = 0; $i < $testimonial['rating']; $i++): ?>
                            <i class="bi bi-star-fill text-warning"></i>
                        <?php endfor; ?>
                    </div>
                    <p class="testimonial-text">"<?php echo htmlspecialchars($testimonial['text']); ?>"</p>
                    <div class="testimonial-author">
                        <h6 class="author-name"><?php echo htmlspecialchars($testimonial['name']); ?></h6>
                        <p class="author-date text-muted"><?php echo htmlspecialchars($testimonial['date']); ?></p>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

