<!-- Location & Hours Section -->
<section id="location" class="location-section py-5">
    <div class="container">
        <div class="text-center mb-5">
            <span class="section-label">Find Us</span>
            <h2 class="section-title"><?php echo htmlspecialchars($config['locations']['title']); ?></h2>
            <p class="section-subtitle"><?php echo htmlspecialchars($config['locations']['subtitle']); ?></p>
        </div>

        <!-- Bento Box Grid -->
        <div class="bento-grid">
            <!-- Large Map Box -->
            <div class="bento-box bento-map">
                <iframe src="<?php echo htmlspecialchars($config['locations']['mapEmbed']); ?>" 
                    width="100%" 
                    height="100%"
                    style="border:0;" 
                    allowfullscreen="" 
                    loading="lazy" 
                    referrerpolicy="no-referrer-when-downgrade">
                </iframe>
            </div>

            <!-- Address Box -->
            <div class="bento-box bento-address">
                <div class="bento-icon">
                    <i class="bi bi-geo-alt-fill"></i>
                </div>
                <h3>Address</h3>
                <p><?php echo htmlspecialchars($restaurant['address']['street']); ?><br>
                    <?php echo htmlspecialchars($restaurant['address']['city']); ?>, <?php echo htmlspecialchars($restaurant['address']['state']); ?>
                    <?php echo htmlspecialchars($restaurant['address']['zip']); ?></p>
                <a href="<?php echo htmlspecialchars($restaurant['geo']['googleMapsUrl']); ?>"
                    class="bento-link" target="_blank" rel="noopener">
                    Get Directions <i class="bi bi-arrow-right ms-1"></i>
                </a>
            </div>

            <!-- Hours Box -->
            <div class="bento-box bento-hours">
                <div class="bento-icon">
                    <i class="bi bi-clock-fill"></i>
                </div>
                <h3>Hours</h3>
                <div class="hours-bento">
                    <?php foreach ($restaurant['hours'] as $day => $hours): ?>
                        <div class="hours-row-bento">
                            <span><?php echo ucfirst(substr($day, 0, 3)); ?></span>
                            <span><?php echo htmlspecialchars($hours); ?></span>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>

            <!-- Contact Box -->
            <div class="bento-box bento-contact">
                <div class="bento-icon">
                    <i class="bi bi-telephone-fill"></i>
                </div>
                <h3>Contact</h3>
                <p>
                    <a href="tel:<?php echo str_replace(['(', ')', ' ', '-'], '', $restaurant['phone']); ?>"><?php echo htmlspecialchars($restaurant['phone']); ?></a><br>
                    <a href="mailto:<?php echo htmlspecialchars($restaurant['email']); ?>"><?php echo htmlspecialchars($restaurant['email']); ?></a>
                </p>
            </div>
        </div>
    </div>
</section>

