<!-- Footer -->
<footer class="footer bg-dark text-light py-5">
    <div class="container">
        <div class="row g-4">
            <div class="col-lg-4">
                <img src="https://assets2.ser.vi/restaurants/806pizzahousemaster/venuelogo/806-pizza-house-logo-main.png" alt="806 Pizza House" class="footer-logo mb-3">
                <p><?php echo htmlspecialchars($restaurant['tagline']); ?></p>
                <div class="social-links mt-3">
                    <?php if (!empty($restaurant['social']['facebook'])): ?>
                    <a href="<?php echo htmlspecialchars($restaurant['social']['facebook']); ?>" 
                       target="_blank" 
                       class="social-link">
                        <i class="bi bi-facebook"></i>
                    </a>
                    <?php endif; ?>
                    
                    <?php if (!empty($restaurant['social']['instagram'])): ?>
                    <a href="<?php echo htmlspecialchars($restaurant['social']['instagram']); ?>" 
                       target="_blank" 
                       class="social-link">
                        <i class="bi bi-instagram"></i>
                    </a>
                    <?php endif; ?>
                    
                    <?php if (!empty($restaurant['social']['yelp'])): ?>
                    <a href="<?php echo htmlspecialchars($restaurant['social']['yelp']); ?>" 
                       target="_blank" 
                       class="social-link">
                        <i class="bi bi-yelp"></i>
                    </a>
                    <?php endif; ?>
                    
                    <?php if (!empty($restaurant['social']['google'])): ?>
                    <a href="<?php echo htmlspecialchars($restaurant['social']['google']); ?>" 
                       target="_blank" 
                       class="social-link">
                        <i class="bi bi-google"></i>
                    </a>
                    <?php endif; ?>
                </div>
            </div>

            <div class="col-lg-4">
                <h5 class="mb-3">Quick Links</h5>
                <ul class="footer-links">
                    <li><a href="#home">Home</a></li>
                    <li><a href="#about">About Us</a></li>
                    <li><a href="#testimonials">Reviews</a></li>
                    <li><a href="#location">Location</a></li>
                </ul>
            </div>

            <div class="col-lg-4">
                <h5 class="mb-3">Contact Us</h5>
                <ul class="footer-contact">
                    <li>
                        <i class="bi bi-geo-alt-fill me-2"></i>
                        <?php echo htmlspecialchars($restaurant['address']['street']); ?><br>
                        <span class="ms-4"><?php echo htmlspecialchars($restaurant['address']['city']); ?>, 
                        <?php echo htmlspecialchars($restaurant['address']['state']); ?> 
                        <?php echo htmlspecialchars($restaurant['address']['zip']); ?></span>
                    </li>
                    <li>
                        <i class="bi bi-telephone-fill me-2"></i>
                        <a href="tel:<?php echo str_replace(['(', ')', ' ', '-'], '', $restaurant['phone']); ?>">
                            <?php echo htmlspecialchars($restaurant['phone']); ?>
                        </a>
                    </li>
                    <li>
                        <i class="bi bi-envelope-fill me-2"></i>
                        <a href="mailto:<?php echo htmlspecialchars($restaurant['email']); ?>">
                            <?php echo htmlspecialchars($restaurant['email']); ?>
                        </a>
                    </li>
                </ul>
            </div>
        </div>

        <hr class="my-4 border-secondary">

        <div class="row">
            <div class="col-md-6 text-center text-md-start">
                <p class="mb-0">&copy; <?php echo date('Y'); ?> <?php echo htmlspecialchars($restaurant['name']); ?>. All Rights Reserved.</p>
            </div>
            <div class="col-md-6 text-center text-md-end">
                <p class="mb-0">Made with <i class="bi bi-heart-fill text-danger"></i> in Plainview, TX</p>
            </div>
        </div>
    </div>

    <!-- Back to Top Button -->
    <button id="backToTop" class="back-to-top" aria-label="Back to top">
        <i class="bi bi-arrow-up"></i>
    </button>
</footer>

