<!-- About Section -->
<section id="about" class="about-section py-5">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6 mb-4 mb-lg-0">
                <div class="about-image-wrapper">
                    <img src="<?php echo htmlspecialchars($about['image']); ?>" 
                         alt="<?php echo htmlspecialchars($restaurant['name']); ?> - Fresh Pizza" 
                         class="img-fluid rounded shadow-lg about-image"
                         loading="lazy">
                </div>
            </div>
            <div class="col-lg-6">
                <div class="about-content">
                    <span class="section-label">Our Story</span>
                    <h2 class="section-title"><?php echo htmlspecialchars($about['title']); ?></h2>
                    <p class="section-subtitle"><?php echo htmlspecialchars($about['subtitle']); ?></p>
                    <div class="about-text">
                        <?php
                        $paragraphs = explode("\\n\\n", $about['content']);
                        foreach ($paragraphs as $paragraph) {
                            echo '<p>' . nl2br(htmlspecialchars(str_replace("\\n", "\n", $paragraph))) . '</p>';
                        }
                        ?>
                    </div>
                    
                    <!-- Stats -->
                    <?php if (!empty($about['stats'])): ?>
                    <div class="row mt-4">
                        <?php foreach ($about['stats'] as $stat): ?>
                        <div class="col-4">
                            <div class="stat-box text-center">
                                <h3 class="stat-number"><?php echo htmlspecialchars($stat['number']); ?></h3>
                                <p class="stat-label"><?php echo htmlspecialchars($stat['label']); ?></p>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                    <?php endif; ?>

                    <!-- Features -->
                    <?php if (!empty($config['features'])): ?>
                    <div class="row mt-4">
                        <?php foreach ($config['features'] as $feature): ?>
                        <div class="col-md-4 mb-3">
                            <div class="feature-item">
                                <i class="bi bi-<?php echo htmlspecialchars($feature['icon']); ?> feature-icon"></i>
                                <h5 class="feature-title"><?php echo htmlspecialchars($feature['title']); ?></h5>
                                <p class="feature-description"><?php echo htmlspecialchars($feature['description']); ?></p>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>

