# 806 Pizza House - Website

Official website for 806 Pizza House located at 1140 Kermit Dr, Plainview, TX.

## Features

- **JSON-Controlled Content**: All website content managed through a single `config.json` file
- **Mobile-responsive design**: Optimized for all devices
- **SEO optimized**: Complete meta tags, schema markup, and structured data
- **Google Maps integration**: Interactive location map
- **Clean URL structure**: .htaccess rewrite rules for SEO-friendly URLs
- **Modern Texas-inspired UI**: Red, orange, and gold color scheme
- **Performance optimized**: Lazy loading, caching, and optimized assets

## Pages

1. **Home Page** (`index.php`) - Main landing page with:
   - Hero section with call-to-action
   - About section with stats
   - Menu highlights (8 featured items)
   - Customer testimonials
   - Location & hours
   - Footer with contact info

## URLs

- **Main Domain**: https://806pizzahouse.com
- **Home Page**: https://806pizzahouse.com/

## Social Links

- **Facebook**: https://www.facebook.com/806pizzahouse/
- **Yelp**: https://www.yelp.com/biz/806-pizza-house-plainview
- **Google**: https://www.google.com/search?q=806+Pizza+House

## File Structure

```
806-pizza-house/
├── assets/
│   ├── css/
│   │   └── style.css              # Main stylesheet
│   ├── images/
│   │   ├── favicon.png            # Favicon
│   │   ├── logo.png               # Restaurant logo
│   │   ├── hero-bg.jpg            # Hero background
│   │   ├── about-pizza.jpg        # About section image
│   │   └── og-image.jpg           # Social media preview
│   └── js/
│       └── main.js                # Main JavaScript
├── sections/
│   ├── navbar.php                 # Navigation bar
│   ├── hero.php                   # Hero section
│   ├── about.php                  # About section
│   ├── menu.php                   # Menu highlights
│   ├── testimonials.php           # Customer reviews
│   ├── location.php               # Location & hours
│   └── footer.php                 # Footer section
├── config.json                    # ⭐ MAIN CONFIGURATION FILE
├── index.php                      # Main landing page
├── .htaccess                      # URL rewrite rules
├── robots.txt                     # Search engine directives
├── sitemap.xml                    # SEO sitemap
└── readme.md                      # Documentation
```

## Configuration

### Editing Content

All website content is controlled by `config.json`. Simply edit this file to update:

- Restaurant name, tagline, and description
- Contact information (phone, email, address)
- Business hours
- Social media links
- Brand colors (primary, secondary, accent)
- Hero section content
- About section content and stats
- Menu highlights (featured items)
- Testimonials
- Google Maps location

### Brand Colors

Current colors (defined in `config.json`):
```json
"colors": {
  "primary": "#d32f2f",      // Red
  "secondary": "#ff6f00",    // Orange
  "accent": "#fbc02d",       // Gold
  "light": "#fff8e1",        // Light cream
  "dark": "#1a1a1a"          // Almost black
}
```

### Menu Items

To feature menu items on the homepage, set `"featured": true` in the `menuHighlights` array in `config.json`.

## Setup Instructions

1. Upload all files to your web server
2. Ensure PHP 7.4+ is enabled on your server
3. Verify .htaccess is working for clean URLs
4. Edit `config.json` to customize your content
5. Replace placeholder images in `assets/images/`
6. Configure SSL certificate for HTTPS (recommended)
7. Update Google Maps embed URL in `config.json`

## Google Maps Setup

1. Go to [Google Maps](https://www.google.com/maps)
2. Search for your restaurant
3. Click "Share" → "Embed a map"
4. Copy the iframe URL
5. Paste it into `config.json` under `locations.mapEmbed`

## Technologies Used

- PHP 7.4+
- HTML5
- CSS3 (Custom styling with Texas theme)
- JavaScript (Vanilla)
- Bootstrap 5.3.2
- Bootstrap Icons 1.11.1
- Google Fonts (Bebas Neue & Roboto)

## Browser Support

- Chrome (latest)
- Firefox (latest)
- Safari (latest)
- Edge (latest)
- Mobile browsers (iOS Safari, Chrome Mobile)

## Performance Features

- Lazy loading for images
- Browser caching via .htaccess
- Optimized CSS and JavaScript
- Smooth scroll animations
- Back-to-top button
- Mobile-first responsive design
- Intersection Observer for scroll animations

## SEO Features

- Structured data (JSON-LD)
- Open Graph tags
- Twitter Card tags
- Canonical URLs
- Sitemap.xml
- Robots.txt
- Geo-location meta tags
- Local business schema
- Optimized meta descriptions
- Keyword-rich content

## Design Theme

The website features a Texas-inspired design:
- **Colors**: Red, orange, and gold (warm, inviting tones)
- **Typography**: Bebas Neue (headings) + Roboto (body)
- **Style**: Bold, modern, family-friendly
- **Imagery**: Focus on food photography and authentic pizza

## Developer

Developed by Ser.vi Worldwide LLC

## Support

For support or customization requests, contact: sal@ser.vi

## License

© 2025 806 Pizza House. All Rights Reserved.

