<?php
// SEO Headers - Allow search engines to index and follow
header('X-Robots-Tag: index, follow, max-snippet:-1, max-image-preview:large, max-video-preview:-1');

// Load configuration
$config = json_decode(file_get_contents('config.json'), true);
$restaurant = $config['restaurant'];
$hero = $config['hero'];
$about = $config['about'];
$specialties = $config['specialties'];
$menuHighlights = array_filter($config['menuHighlights'], function ($item) {
    return isset($item['featured']) && $item['featured'] === true;
});
$testimonials = $config['testimonials'];
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <!-- Google tag (gtag.js) - Enhanced Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-XQN69TK30Q"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());

      // Enhanced measurement configuration
      gtag('config', 'G-XQN69TK30Q', {
        'send_page_view': true,
        'cookie_flags': 'SameSite=None;Secure',
        'anonymize_ip': true,
        'allow_google_signals': true,
        'allow_ad_personalization_signals': true
      });

      // Track phone clicks
      document.addEventListener('DOMContentLoaded', function() {
        document.querySelectorAll('a[href^="tel:"]').forEach(function(link) {
          link.addEventListener('click', function() {
            gtag('event', 'phone_call', {
              'event_category': 'Contact',
              'event_label': 'Phone Click',
              'value': link.getAttribute('href')
            });
          });
        });

        // Track email clicks
        document.querySelectorAll('a[href^="mailto:"]').forEach(function(link) {
          link.addEventListener('click', function() {
            gtag('event', 'email_click', {
              'event_category': 'Contact',
              'event_label': 'Email Click',
              'value': link.getAttribute('href')
            });
          });
        });

        // Track directions clicks
        document.querySelectorAll('a[href*="maps"]').forEach(function(link) {
          link.addEventListener('click', function() {
            gtag('event', 'get_directions', {
              'event_category': 'Navigation',
              'event_label': 'Get Directions Click'
            });
          });
        });

        // Track social media clicks
        document.querySelectorAll('.social-link').forEach(function(link) {
          link.addEventListener('click', function() {
            var platform = 'Unknown';
            if (link.href.includes('facebook')) platform = 'Facebook';
            else if (link.href.includes('instagram')) platform = 'Instagram';
            else if (link.href.includes('yelp')) platform = 'Yelp';
            else if (link.href.includes('google')) platform = 'Google';
            
            gtag('event', 'social_click', {
              'event_category': 'Social Media',
              'event_label': platform,
              'value': link.href
            });
          });
        });

        // Track scroll depth
        var scrollDepth = 0;
        window.addEventListener('scroll', function() {
          var scrollPercent = Math.round((window.scrollY / (document.documentElement.scrollHeight - window.innerHeight)) * 100);
          if (scrollPercent > scrollDepth && scrollPercent % 25 === 0) {
            scrollDepth = scrollPercent;
            gtag('event', 'scroll_depth', {
              'event_category': 'Engagement',
              'event_label': scrollPercent + '%',
              'value': scrollPercent
            });
          }
        });

        // Track time on page
        var startTime = new Date().getTime();
        window.addEventListener('beforeunload', function() {
          var timeSpent = Math.round((new Date().getTime() - startTime) / 1000);
          gtag('event', 'time_on_page', {
            'event_category': 'Engagement',
            'event_label': 'Seconds',
            'value': timeSpent
          });
        });
      });
    </script>

    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=5.0, user-scalable=yes">

    <!-- Primary Meta Tags -->
    <title>806 Pizza House Plainview TX | Best Pizza in Plainview | Order Now</title>
    <meta name="title" content="806 Pizza House Plainview TX | Best Pizza in Plainview | Order Now">
    <meta name="description"
        content="Best pizza in Plainview, TX! 806 Pizza House serves authentic pizza, pasta, wings & salads. Fresh ingredients, great taste. Dine-in, takeout & delivery. Order now!">

    <!-- Primary keywords + local pack boosters -->
    <meta name="keywords"
        content="Best Pizza Plainview TX, 806 Pizza House, Pizza Delivery Plainview, Pizza near me Plainview, Fresh Pizza Plainview, Italian Food Plainview, Pizza 79072, 806 Pizza, pizzeria Plainview TX, best pizza Plainview, pasta Plainview, wings Plainview, takeout Plainview, pizza delivery 79072">

    <!-- Canonical URL -->
    <link rel="canonical" href="https://806pizzahouse.com/">

    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="restaurant">
    <meta property="og:url" content="https://806pizzahouse.com/">
    <meta property="og:title" content="806 Pizza House Plainview TX | Best Pizza in Plainview | Order Now">
    <meta property="og:description"
        content="Authentic pizza, pasta, seafood, BBQ & chicken in Plainview, TX. Lunch buffet, dine-in, drive-thru, takeout & delivery. Order online!">
    <meta property="og:image"
        content="https://assets2.ser.vi/brand/806pizzahouse/background/806.webp">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:image:alt" content="806 Pizza House - Best Pizza in Plainview, TX">
    <meta property="og:locale" content="en_US">
    <meta property="og:site_name" content="806 Pizza House">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="https://806pizzahouse.com/">
    <meta property="twitter:title" content="806 Pizza House Plainview TX | Best Pizza in Plainview | Order Now">
    <meta property="twitter:description"
        content="Authentic pizza, pasta, seafood, BBQ & chicken. Lunch buffet available. Order now!">
    <meta property="twitter:image" content="https://assets2.ser.vi/brand/806pizzahouse/background/806.webp">
    <meta property="twitter:image:alt" content="806 Pizza House - Best Pizza in Plainview, TX">
    
    <!-- Local Business Schema Markup -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "Restaurant",
        "@id": "https://806pizzahouse.com/",
        "name": "806 Pizza House",
        "image": "https://806pizzahouse.com/assets/images/logo.png",
        "url": "https://806pizzahouse.com/",
        "telephone": "<?php echo $restaurant['phone']; ?>",
        "email": "<?php echo $restaurant['email']; ?>",
        "priceRange": "$$",
        "servesCuisine": ["Italian", "Pizza", "Pasta", "American"],
        "acceptsReservations": "False",
        "address": {
            "@type": "PostalAddress",
            "streetAddress": "<?php echo $restaurant['address']['street']; ?>",
            "addressLocality": "<?php echo $restaurant['address']['city']; ?>",
            "addressRegion": "<?php echo $restaurant['address']['state']; ?>",
            "postalCode": "<?php echo $restaurant['address']['zip']; ?>",
            "addressCountry": "US"
        },
        "geo": {
            "@type": "GeoCoordinates",
            "latitude": <?php echo $restaurant['geo']['latitude']; ?>,
            "longitude": <?php echo $restaurant['geo']['longitude']; ?>
        },
        "openingHoursSpecification": [
            <?php
            $daysMap = [
                'monday' => 'Monday',
                'tuesday' => 'Tuesday',
                'wednesday' => 'Wednesday',
                'thursday' => 'Thursday',
                'friday' => 'Friday',
                'saturday' => 'Saturday',
                'sunday' => 'Sunday'
            ];
            $hoursArray = [];
            foreach ($restaurant['hours'] as $day => $hours) {
                $times = explode(' - ', $hours);
                $hoursArray[] = json_encode([
                    "@type" => "OpeningHoursSpecification",
                    "dayOfWeek" => $daysMap[$day],
                    "opens" => date('H:i', strtotime($times[0])),
                    "closes" => date('H:i', strtotime($times[1]))
                ], JSON_UNESCAPED_SLASHES);
            }
            echo implode(',', $hoursArray);
            ?>
        ],
        "sameAs": [
            "<?php echo $restaurant['social']['google']; ?>",
            "<?php echo $restaurant['social']['facebook']; ?>",
            "<?php echo $restaurant['social']['yelp']; ?>"
        ],
        "menu": "https://806pizzahouse.com/#menu",
        "aggregateRating": {
            "@type": "AggregateRating",
            "ratingValue": "4.5",
            "reviewCount": "100"
        }
    }
    </script>

    <!-- Geo tags for Google's AI/local pack -->
    <meta name="geo.position" content="<?php echo $restaurant['geo']['latitude']; ?>;<?php echo $restaurant['geo']['longitude']; ?>">
    <meta name="geo.placename" content="Plainview, TX">
    <meta name="geo.region" content="US-TX">
    <meta name="ICBM" content="<?php echo $restaurant['geo']['latitude']; ?>, <?php echo $restaurant['geo']['longitude']; ?>">

    <!-- Robots Meta -->
    <meta name="robots" content="index, follow, max-image-preview:large, max-snippet:-1, max-video-preview:-1">
    <meta name="googlebot" content="index, follow">

    <!-- Language -->
    <meta http-equiv="content-language" content="en-US">

    <!-- Mobile Optimization -->
    <meta name="theme-color" content="<?php echo $restaurant['colors']['primary']; ?>">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="apple-mobile-web-app-title" content="806 Pizza House">
    <meta name="format-detection" content="telephone=yes">
    <meta name="HandheldFriendly" content="true">

    <!-- Preconnect for Performance -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="preconnect" href="https://cdn.jsdelivr.net">
    <link rel="preconnect" href="https://assets2.ser.vi" crossorigin>
    <link rel="dns-prefetch" href="https://assets2.ser.vi">
    
    <!-- Preload Hero Images -->
    <link rel="preload" as="image" href="https://assets2.ser.vi/brand/806pizzahouse/background/806.webp" fetchpriority="high">
    <link rel="preload" as="image" href="https://assets2.ser.vi/brand/806pizzahouse/feature_image/pizza-2.webp">
    <link rel="preload" as="image" href="https://assets2.ser.vi/brand/806pizzahouse/feature_image/pizza.webp">
    <link rel="preload" as="image" href="https://assets2.ser.vi/brand/806pizzahouse/feature_image/hero-banner.webp">

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">

    <!-- Google Fonts -->
    <link
        href="https://fonts.googleapis.com/css2?family=Bebas+Neue&family=Roboto:wght@300;400;500;700&display=swap"
        rel="stylesheet">

    <!-- Custom CSS -->
    <link rel="stylesheet" href="assets/css/style.css">

    <!-- Favicon -->
    <link rel="icon" type="image/png" href="https://assets2.ser.vi/restaurants/806pizzahousemaster/venuelogo/806-pizza-house-logo-main.png">
    <link rel="apple-touch-icon" sizes="180x180" href="https://assets2.ser.vi/restaurants/806pizzahousemaster/venuelogo/806-pizza-house-logo-main.png">
</head>

<body>

    <!-- Navigation -->
    <?php include 'sections/navbar.php'; ?>

    <!-- Hero Section -->
    <?php include 'sections/hero.php'; ?>

    <!-- About Section -->
    <?php include 'sections/about.php'; ?>

    <!-- Testimonials Section -->
    <?php include 'sections/testimonials.php'; ?>

    <!-- Location & Hours Section -->
    <?php include 'sections/location.php'; ?>

    <!-- Footer -->
    <?php include 'sections/footer.php'; ?>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

    <!-- Custom JS -->
    <script src="assets/js/main.js"></script>

</body>

</html>

