# Image Assets for 806 Pizza House

This directory contains all image assets for the website.

## Required Images

Replace these placeholder images with your actual restaurant images:

### Logo & Branding
- **logo.png** (500x500px recommended)
  - Restaurant logo for navbar and footer
  - Transparent background preferred
  
- **favicon.png** (32x32px or 64x64px)
  - Small icon for browser tab
  - Simple, recognizable design

### Hero Section
- **hero-bg.jpg** (1920x1080px recommended)
  - Main background image for hero section
  - High-quality pizza or restaurant interior photo
  - Should work well with red/orange overlay

### About Section
- **about-pizza.jpg** (800x600px recommended)
  - Image showing fresh pizza or kitchen
  - Should convey authenticity and quality

### Social Media
- **og-image.jpg** (1200x630px)
  - Open Graph image for social media sharing
  - Include restaurant name and appetizing food photo
  - Used when sharing on Facebook, Twitter, etc.

## Image Optimization Tips

1. **Compress images** before uploading
   - Use tools like TinyPNG, ImageOptim, or Squoosh
   - Aim for under 200KB per image

2. **Use appropriate formats**
   - JPEG for photos
   - PNG for logos with transparency
   - WebP for modern browsers (optional)

3. **Responsive images**
   - Provide multiple sizes for different devices
   - Use srcset attribute for optimization

4. **Alt text**
   - Always include descriptive alt text
   - Helps with SEO and accessibility

## Current Image Sources

The website currently uses placeholder images from Unsplash:
- Menu items: Unsplash stock photos
- Replace with actual menu item photos for best results

## Recommended Image Sizes

| Image Type | Dimensions | Format | Max Size |
|------------|-----------|--------|----------|
| Logo | 500x500px | PNG | 50KB |
| Favicon | 64x64px | PNG | 10KB |
| Hero Background | 1920x1080px | JPG | 200KB |
| About Image | 800x600px | JPG | 150KB |
| Menu Items | 600x600px | JPG | 100KB |
| OG Image | 1200x630px | JPG | 150KB |

## Adding New Images

1. Place image files in this directory
2. Update references in `config.json`
3. Test on different devices
4. Verify loading speed

## Copyright

Ensure all images are:
- Owned by you
- Licensed for commercial use
- Properly attributed if required
- Not copyrighted by others

---

**Note**: The website will work with placeholder images, but using real photos of your restaurant and food will significantly improve customer engagement and conversions.

